@extends('admin.layout.master')

@section('body')
         <div class="card">


             <div class="card-header bg-white font-weight-bold">
                 <h4>{{$page_title}}</h4>
             </div>
                <div class="card-body">
                    <div class="table-responsive">

                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <th> SL </th>
                                <th> Username </th>
                                <th> Exchange From</th>
                                <th> Amount	 </th>

                                <th> Exchange From</th>
                                <th> Amount	 </th>

                                <th> Status </th>
                                <th> Details </th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($exchange as $k=>$data)
                                <tr>
                                    <td>{{++$k}}</td>
                                    <td>
                                        <a href="{{route('user.single',$data->user->id)}}"> <strong>{{$data->user->username}}</strong></a>
                                    </td>
                                    <td>{{$data->send_method->name}}</td>
                                    <td> <strong>{{number_format($data->send_amount, $basic->decimal)}}  </strong></td>

                                    <td>{{$data->receive_method->name}}</td>

                                    <td> <strong>{{number_format($data->receive_amount, $basic->decimal)}}   </strong></td>
                                    <td>
                                        @if($data->status == 2)
                                            <span  class="badge  badge-pill  badge-success "> Confirmed </span>
                                        @elseif($data->status == 1)
                                            <span class="badge  badge-pill  badge-warning ">Pending </span>
                                        @elseif($data->status == -1)
                                            <span class="badge  badge-pill  badge-danger ">Cancel </span>
                                        @elseif($data->status == -2)
                                            <span class="badge  badge-pill  badge-danger ">Refund </span>
                                        @endif
                                    </td>
                                    <td>
                                        <a class="btn btn-success  " href="{{route('admin.exchange.info',$data->id)}}" >
                                            <i class="fa fa-eye"></i> Details
                                        </a>
                                    </td>

                                </tr>
                            @endforeach
                            <tbody>
                        </table>

                        {!!  $exchange->links()!!}
                    </div>
                </div>
            </div>


@endsection